export type SearchResult = {
  UserInfoSearch: UserInfoSearch;
}

export type UserInfoSearch = {
  searchID:           string;
  responseStatusStrg: string;
  numOfMatches:       number;
  totalMatches:       number;
  UserInfo:           UserInfo[];
}

export type UserInfo = {
  employeeNo:        string;
  name:              string;
  userType:          string;
  closeDelayEnabled: boolean;
  Valid:             Valid;
  belongGroup:       string;
  password:          string;
  doorRight:         string;
  RightPlan:         RightPlan[];
  maxOpenDoorTime:   number;
  openDoorTime:      number;
  roomNumber:        number;
  floorNumber:       number;
  localUIRight:      boolean;
  gender:            string;
  numOfCard:         number;
  numOfFP:           number;
  numOfFace:         number;
  PersonInfoExtends: PersonInfoExtend[];
  faceURL:           string;
  picID:             string;
}

export type PersonInfoExtend = {
  value: string;
}

export type RightPlan = {
  doorNo:         number;
  planTemplateNo: string;
}

export type Valid = {
  enable:    boolean;
  beginTime: Date;
  endTime:   Date;
  timeType:  string;
}

// Own types

export type Config = {
  ip: string;
  user: string;
  password: string;
}

export type User = {
  id: string;
  name: string;
  imageUrl: string;
}